﻿// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License (Ms-PL).
// Please see http://go.microsoft.com/fwlink/?LinkID=131993 for details.
// All other rights reserved.

using System;
using NU = NUnit.Framework;

namespace Microsoft.Silverlight.Testing.UnitTesting.Metadata.NUnit
{
    /// <summary>
    /// The set of provider attributes.
    /// </summary>
    internal static class ProviderAttributes
    {
        /// <summary>
        /// Initializes the NUnit metadata provider.
        /// </summary>
        static ProviderAttributes()
        {
            TestClass = typeof(NU.TestFixtureAttribute);
            IgnoreAttribute = typeof(NU.IgnoreAttribute);
            ClassInitialize = typeof(NU.TestFixtureSetUpAttribute);
            ClassCleanup = typeof(NU.TestFixtureTearDownAttribute);
            TestInitialize = typeof(NU.SetUpAttribute);
            TestCleanup = typeof(NU.TearDownAttribute);
            DescriptionAttribute = typeof(NU.DescriptionAttribute);
            ExpectedExceptionAttribute = typeof(NU.ExpectedExceptionAttribute);
            TestMethod = typeof(NU.TestAttribute);
        }

        /// <summary>
        /// Gets VSTT [TestClass] attribute.
        /// </summary>
        public static Type TestClass { get; private set; }
        
        /// <summary>
        /// Gets VSTT [Ignore] attribute.
        /// </summary>
        public static Type IgnoreAttribute { get; private set; }
        
        /// <summary>
        /// Gets VSTT [ClassInitialize] attribute.
        /// </summary>
        public static Type ClassInitialize { get; private set; }

        /// <summary>
        /// Gets VSTT [ClassCleanup] attribute.
        /// </summary>
        public static Type ClassCleanup { get; private set; }
        
        /// <summary>
        /// Gets VSTT [TestInitialize] attribute.
        /// </summary>
        public static Type TestInitialize { get; private set; }
        
        /// <summary>
        /// Gets VSTT [TestCleanup] attribute.
        /// </summary>
        public static Type TestCleanup { get; private set; }
        
        /// <summary>
        /// Gets VSTT [Description] attribute.
        /// </summary>
        public static Type DescriptionAttribute { get; private set; }
        
        /// <summary>
        /// Gets VSTT [ExpectedException] attribute.
        /// </summary>
        public static Type ExpectedExceptionAttribute { get; private set; }
        
        /// <summary>
        /// Gets VSTT [TestMethod] attribute.
        /// </summary>
        public static Type TestMethod { get; private set; }
    }
}